package net.senohrabek.marcus.search.schema

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class FieldSchema(
    val type: FieldSchemaType,
    val store: Boolean = true,
    val indexed: Boolean = true,
    val useKeyValueStorage: Boolean = false,
    val docValues: Boolean? = null,
    val analyzer: String? = null,
    val normalized: Boolean = true,
    val subfields: Map<String, FieldSchema> = emptyMap()
)

@Serializable
enum class FieldSchemaType {
    @SerialName("string")
    String,
    @SerialName("text")
    Text,
    @SerialName("int")
    Int,
    @SerialName("long")
    Long,
    @SerialName("float")
    Float,
    @SerialName("double")
    Double
}