package net.senohrabek.marcus.search.queries.builders

import net.senohrabek.marcus.search.queries.BoolQuery
import net.senohrabek.marcus.search.queries.Query

class BoolQueryBuilder: QueryBuilder<BoolQuery> {
    val must = mutableListOf<Query>()
    val mustNot = mutableListOf<Query>()
    val should = mutableListOf<Query>()
    val filter = mutableListOf<Query>()

    var minimumShouldMatch: Int? = null

    fun must(query: Query) {
        must.add(query)
    }

    fun mustNot(query: Query) {
        mustNot.add(query)
    }

    fun should(query: Query) {
        should.add(query)
    }

    fun filter(query: Query) {
        filter.add(query)
    }

    override fun build() = BoolQuery(
        must = must,
        mustNot = mustNot,
        should = should,
        filter = filter,
        minimumShouldMatch = minimumShouldMatch
    )
}

fun boolQuery(builder: BoolQueryBuilder.() -> Unit): BoolQuery {
    return BoolQueryBuilder().apply(builder).build()
}