package net.senohrabek.marcus.search.builders

import net.senohrabek.marcus.search.*
import net.senohrabek.marcus.search.docs.*

class IndexRequestBuilder: FieldsBuilder() {
    private val nested = mutableMapOf<String, MutableList<Map<String, FieldValue>>>()

    fun nested(name: String, callback: FieldsBuilder.() -> Unit) {
        val fieldsBuilder = FieldsBuilder().apply(callback).buildFields()
        nested.getOrPut(name) {
            mutableListOf()
        }.add(fieldsBuilder)
    }

    fun build() = IndexRequest(buildFields(), nested)
}

open class FieldsBuilder {
    private val fields = mutableMapOf<String, FieldValue>()

    fun field(name: String, value: String) = text(name, value)

    fun string(name: String, value: String) {
        fields[name] = StringFieldValue(value)
    }

    fun text(name: String, value: String) {
        fields[name] = TextFieldValue(value)
    }

    fun field(name: String, value: Int) {
        fields[name] = IntFieldValue(value)
    }

    fun field(name: String, value: Boolean) {
        fields[name] = BoolFieldValue(value)
    }

    fun field(name: String, value: Float) {
        fields[name] = FloatFieldValue(value)
    }

    fun field(name: String, value: Double) {
        fields[name] = DoubleFieldValue(value)
    }

    fun buildFields() = fields.toMap()
}

fun indexRequest(callback: IndexRequestBuilder.() -> Unit): IndexRequest {
    return IndexRequestBuilder().apply(callback).build()
}
