package net.senohrabek.marcus.search

import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonPrimitive

@Serializable
data class SearchResponse(
    val total: Long,
    val docs: List<Document>,
    val timing: SearchTiming
)

@Serializable
data class SearchTiming(
    val queryTime: Timing,
    val readTime: Timing,
    val dbTime: Timing
)

@Serializable
data class Timing(
    val min: Long,
    val max: Long,
    val sum: Long,
    val count: Long
) {
    val avg: Long
        get() = sum / count
}

@Serializable
data class Document(
    val id: String,
    val fields: Map<String, JsonPrimitive>,
    val score: Float
)